using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using gov.va.med.vbecs;
using gov.va.med.vbecs.Common;
using System.Text.RegularExpressions;
using System.Runtime.InteropServices;

namespace gov.va.med.vbecs.GUI.controls
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/3/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Class ProductCodeTextbox
	///Extended BarcodeTextbox control with additional BarcodeType property, for Product Code entry.
	///</summary>
	public class ProductCodeTextbox : gov.va.med.vbecs.GUI.controls.BarcodeTextbox
	{

		/// <summary>
		/// Determines if product code is ISBT-128 or Codabar.
		/// </summary>
		private BarcodeType barcodeType = BarcodeType.None;

		/// <summary>
		/// isbtScan
		/// </summary>
		public Common.ISBTScan isbtScan = Common.ISBTScan.Unknown;

		private bool _Valid = true;
		private int _maxLength = 10;

		/// <summary>
		/// EventHandler object
		/// </summary>
		public event EventHandler OtherIsbtFieldScanned;

		/// <summary>
		/// Variable to keep recursive focus from occurring when changing focus in a leave event; A value of true indicates
		/// that the form has already started processing the leave event and it shouldn't try to do it again
		/// </summary>
		private bool _recursionGuard = false;
	
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// BarcodeTypeChanged EventHandler
		/// </summary>
		public event EventHandler BarcodeTypeChanged;

		/// <summary>
		/// Raises barcode type changed event handler
		/// </summary>
		protected virtual void OnBarcodeTypeChanged()
		{
			if(BarcodeTypeChanged != null)
				BarcodeTypeChanged(this, EventArgs.Empty);
		}
		
		/// <summary>
		/// Raises event if a barcode is scanned into this text box that is not a product code.
		/// </summary>
		protected virtual void OnOtherIsbtFieldScanned()
		{
			if(OtherIsbtFieldScanned != null)
				OtherIsbtFieldScanned(this, EventArgs.Empty);
		}

		/// <summary>
		/// ProductCodeTextbox control class constructor.
		/// </summary>
		/// <param name="container"></param>
		public ProductCodeTextbox(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
		}

		/// <summary>
		/// ProductCodeTextbox control class constructor.
		/// </summary>
		public ProductCodeTextbox()
		{
			InitializeComponent();
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			//CR 2128
			this.MaxLength = 10;
		}
		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/3/2002</CreationDate>
		/// <summary>
		/// Barcode Type property. Returns BarcodeType enum of blood product code entered.
		/// </summary>
		[
		Category("Behavior"),
		Description("Barcode Type"),
		Bindable(true),
		Browsable(true),
		]
		public new BarcodeType BarcodeType
		{
			get
			{
				return barcodeType; 
			}
			set
			{
				barcodeType = value;
				OnBarcodeTypeChanged();
			}
		}
		///<Developers>
		///	<Developer>Carrie Van Stedumr</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2006</CreationDate>
		/// <summary>
		/// max length of text box
		/// </summary>
		[
		Category("Behavior"),
		Description("Max Length"),
		Bindable(true),
		Browsable(true),
		]
		public override sealed int MaxLength
		{
			get
			{
				//return maxLength;
				return this._maxLength;
			}
			set
			{
				//CR 2128
				//A unit ID's max length must always be 15
				if(base.MaxLength != 10)
				{
					this._maxLength = 10;
					base.MaxLength = 10;
				}
			}
		}

		/// <summary>
		/// Get the value of ProductCodeValid
		/// </summary>
		public bool ProductCodeValid
		{
			get
			{
				return this._Valid;
			}
		}

#if NUNIT
		/// <summary>
		/// TeastOnLeave method. Allows NUnit to test protected OnLeave method.
		/// </summary>
		public void TestOnLeave()
		{
			this.OnLeave(EventArgs.Empty);
		}

#endif

		/// <summary>
		/// Current recursion status of the form
		/// </summary>
		public virtual bool RecursionGuard
		{
			get
			{
				return _recursionGuard;
			}
			set
			{
				this._recursionGuard = value;
			}
		}

		/// <summary>
		/// GetKeyState
		/// </summary>
		/// <param name="keyCode"></param>
		/// <returns></returns>
		[DllImport("user32.dll", CharSet=CharSet.Auto, ExactSpelling=true, CallingConvention=CallingConvention.Winapi)] 
		public static extern short GetKeyState(int keyCode); 

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// Override for Leave event to determine format of blood product code entered. 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLeave(EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					this._Valid = true;
					Regex _regexCodabar = Common.RegularExpressions.CodabarProductCode();
					Regex _regexISBT128 = Common.RegularExpressions.ISBT128ProductCode();
			
					string _txt = this.Text;

					isbtScan = Common.Utility.GetISBTFromString(this.Text);
			
					//Scanning barcode with CAPS LOCK ON will cause uppercase chars
					//to be displayed as lower case, and vice versa.
					//We'll switch them back here...
					bool capsLock = (((ushort) GetKeyState(0x14 /*VK_CAPITAL*/)) & 0xffff) != 0;
					if (capsLock && this.Barcode)
					{
						for(int i = 0 ; i < _txt.Length; i++)
						{
							if (char.IsLower(_txt[i]))
							{
								_txt = _txt.Replace(_txt[i], char.ToUpper(_txt[i]));
							}
							else if (char.IsUpper(_txt[i]))
							{
								_txt = _txt.Replace(_txt[i], char.ToLower(_txt[i]));
							}
						}
					}
					else
					{
						int nIndex = this.Text.IndexOf("e");
						if(nIndex > -1)
						{
							_txt =_txt.Replace(_txt.Substring(nIndex, 1), "E");
						}
					}

					//BR_1.14
					if (_regexISBT128.IsMatch(_txt))
					{
						this.BarcodeType = BarcodeType.ISBT128;
						_txt = _txt.Replace("=<","");
						this.isbtScan = Common.ISBTScan.ProductCode;
						if(_txt.Length > 8)
						{
							_txt = _txt.Substring(0,8);
						}
					}
						//BR_1.13
					else if (_regexCodabar.IsMatch(_txt))
					{
						if (_txt.Length == 7)
						{
							_txt = _txt.Substring(1,5);
						}
						this.BarcodeType = BarcodeType.Codabar;
					}
					else
					{
						if(_txt.Trim().Length > 0)
						{
							_Valid = false;
						}
						this.BarcodeType = BarcodeType.None;
					}

					// If an ISBT field other than product code is scanned
					if (isbtScan != Common.ISBTScan.ProductCode && isbtScan != Common.ISBTScan.Unknown)
					{
						_Valid = false;
						OnOtherIsbtFieldScanned();			
					}
					//
					this.Text = _txt;

		

					base.OnLeave(e);
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
		}

		/// <summary>
		/// This is used to set the text of a control from another control.  It is used when
		/// an ISBT field is scanned into the wrong text box.  That control passes the text to 
		/// correct control and reset it with this code.
		/// </summary>
		public void SetControl()
		{
			Regex _regexCodabar = Common.RegularExpressions.CodabarProductCode();
			Regex _regexISBT128 = Common.RegularExpressions.ISBT128ProductCode();
			
			string _txt = this.Text;
				
			isbtScan = Common.Utility.GetISBTFromString(this.Text);
			
			//BR_1.14
			if (_regexISBT128.IsMatch(_txt))
			{
				this.BarcodeType = BarcodeType.ISBT128;
				_txt = _txt.Replace("=<","");
				this.isbtScan = Common.ISBTScan.ProductCode;
			}
				//BR_1.13
			else if (_regexCodabar.IsMatch(_txt))
			{
				this.BarcodeType = BarcodeType.Codabar;
			}
			else
			{
				this.BarcodeType = BarcodeType.None;
			}
			//
			this.Text = _txt;
		}
	}
}

